function residual = static_resid(T, y, x, params, T_flag)
% function residual = static_resid(T, y, x, params, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T         [#temp variables by 1]  double   vector of temporary terms to be filled by function
%   y         [M_.endo_nbr by 1]      double   vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1]       double   vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1]     double   vector of parameter values in declaration order
%                                              to evaluate the model
%   T_flag    boolean                 boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = NK_financial.static_resid_tt(T, y, x, params);
end
residual = zeros(51, 1);
lhs = y(42);
rhs = T(4)*y(3)+y(42)*T(6);
residual(1) = lhs - rhs;
lhs = y(1);
rhs = y(3)+T(6)*y(1);
residual(2) = lhs - rhs;
lhs = y(2);
rhs = y(3)-params(28)*(y(18)-(y(18)))^2+T(6)*y(2);
residual(3) = lhs - rhs;
lhs = y(3);
rhs = T(8)*T(9);
residual(4) = lhs - rhs;
lhs = y(6);
rhs = y(6)*(1-params(3))/(1+T(1))+(1-y(7))*y(9)*y(10);
residual(5) = lhs - rhs;
lhs = y(8);
rhs = 1+T(1);
residual(6) = lhs - rhs;
lhs = y(7);
rhs = params(8)*(y(8)-1-T(1))^2;
residual(7) = lhs - rhs;
lhs = y(11);
rhs = (y(8)-1-T(1))*2*params(8);
residual(8) = lhs - rhs;
lhs = y(12);
rhs = (1-params(6))*y(3)/T(7)-y(3)*(1-params(6))*T(2)*params(7)/T(5)/((1+T(1))*y(4)-y(4)*params(7));
residual(9) = lhs - rhs;
lhs = y(13);
rhs = (-y(51))/y(12);
residual(10) = lhs - rhs;
lhs = 1;
rhs = y(15)*y(16)*T(3);
residual(11) = lhs - rhs;
lhs = y(17);
rhs = T(3)*(y(14)+(1-params(3))*y(17));
residual(12) = lhs - rhs;
lhs = 1;
rhs = y(10)*y(17)*(1-y(7)-y(8)*y(11))+y(10)*T(11);
residual(13) = lhs - rhs;
lhs = y(16);
rhs = y(18)/y(19);
residual(14) = lhs - rhs;
lhs = y(51);
rhs = y(3)*(-(1-params(6)))*T(12);
residual(15) = lhs - rhs;
lhs = y(20);
rhs = (1+T(1))*y(19);
residual(16) = lhs - rhs;
lhs = y(22);
rhs = y(13)*T(13)*y(23)*y(24)+y(22)*T(3)*(1+T(1))*params(10)*T(16);
residual(17) = lhs - rhs;
lhs = y(25);
rhs = y(23)+y(25)*T(3)*params(10)*T(14)/(y(19)*T(17));
residual(18) = lhs - rhs;
lhs = y(26);
rhs = y(22)/(y(21)*y(25));
residual(19) = lhs - rhs;
lhs = 1;
rhs = params(10)*T(19)^(1-params(5))+(1-params(10))*y(26)^(1-params(5));
residual(20) = lhs - rhs;
lhs = y(27);
rhs = y(27)*params(10)*T(16)+(1-params(10))*y(26)^(-params(5));
residual(21) = lhs - rhs;
lhs = y(28);
rhs = T(20)*T(22);
residual(22) = lhs - rhs;
lhs = y(21);
rhs = y(28)*params(2)*y(30)/y(23);
residual(23) = lhs - rhs;
lhs = y(14);
rhs = y(28)*(1-params(2))*y(30)/T(21);
residual(24) = lhs - rhs;
lhs = y(31);
rhs = y(30);
residual(25) = lhs - rhs;
lhs = y(32);
rhs = y(31)*T(24)*y(34)+y(32)*T(3)*(1+T(1))*params(9)*T(27);
residual(26) = lhs - rhs;
lhs = y(35);
rhs = y(33)+y(35)*T(3)*(1+T(1))*params(9)*T(28)/T(29);
residual(27) = lhs - rhs;
lhs = y(36);
rhs = y(32)/y(35);
residual(28) = lhs - rhs;
lhs = 1;
rhs = params(9)*(T(30)/y(19))^(1-params(4))+(1-params(9))*y(36)^(1-params(4));
residual(29) = lhs - rhs;
lhs = y(37);
rhs = y(37)*params(9)*T(27)+(1-params(9))*y(36)^(-params(4));
residual(30) = lhs - rhs;
lhs = log(y(18)/(y(18)));
rhs = log(y(18)/(y(18)))*params(16)+(1-params(16))*(params(17)*log(y(19)/(y(19)))+params(18)*log(y(33)/(y(33))))+log(y(38));
residual(31) = lhs - rhs;
lhs = y(33);
rhs = y(9)+y(4)+y(39);
residual(32) = lhs - rhs;
lhs = y(5);
rhs = y(23)*y(27);
residual(33) = lhs - rhs;
lhs = y(28);
rhs = y(33)*y(37);
residual(34) = lhs - rhs;
lhs = y(40);
rhs = (y(14)+(1-params(3))*y(17))/y(17);
residual(35) = lhs - rhs;
lhs = y(41);
rhs = y(40)-y(16);
residual(36) = lhs - rhs;
lhs = log(y(29))-log((y(29)));
rhs = (log(y(29))-log((y(29))))*params(20)+x(1);
residual(37) = lhs - rhs;
lhs = log(y(39))-log((y(39)));
rhs = (log(y(39))-log((y(39))))*params(21)+x(2);
residual(38) = lhs - rhs;
lhs = log(y(34))-log((y(34)));
rhs = (log(y(34))-log((y(34))))*params(22)+x(3);
residual(39) = lhs - rhs;
lhs = log(y(24))-log((y(24)));
rhs = (log(y(24))-log((y(24))))*params(23)+x(6);
residual(40) = lhs - rhs;
lhs = log(y(10))-log((y(10)));
rhs = (log(y(10))-log((y(10))))*params(26)+x(5);
residual(41) = lhs - rhs;
lhs = log(y(38))-log((y(38)));
rhs = (log(y(38))-log((y(38))))*params(24)+x(4);
residual(42) = lhs - rhs;
lhs = log(y(15))-log((y(15)));
rhs = (log(y(15))-log((y(15))))*params(25)+x(7);
residual(43) = lhs - rhs;
lhs = y(43);
rhs = log(1+T(1));
residual(44) = lhs - rhs;
lhs = y(44);
rhs = log(1+T(1));
residual(45) = lhs - rhs;
lhs = y(49);
rhs = log(1+T(1));
residual(46) = lhs - rhs;
lhs = y(50);
rhs = log(1+T(1));
residual(47) = lhs - rhs;
lhs = y(47);
rhs = (y(23)-(y(23)))/(y(23));
residual(48) = lhs - rhs;
lhs = y(46);
rhs = y(18)-1;
residual(49) = lhs - rhs;
lhs = y(45);
rhs = log(y(19));
residual(50) = lhs - rhs;
lhs = y(48);
rhs = y(41);
residual(51) = lhs - rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
end
